class Array

  # 'array' is the unsorted set of objects
  # 'att_sym' is the symbol of the attribute each object in array, that is represented in index_array
  # 'index_array' is the ordered array of values
  def sort_with_index(array, att_sym, index_array)
    return array.sort do |a, b|
      index_array.index(a.send(att_sym)).to_i <=> index_array.index(b.send(att_sym)).to_i
    end
  end


  def avg
    s = sum
    return sum.to_f / self.size
  end


  # Compte le nombre d'occurrences d'un lment
  def compter(truc)
    return count
  end

  
  def count(truc)
    nb = 0
    each {|x|
      nb += 1 if x == truc
    }
    return nb
  end
  
  # Rcupre un lment  un endroit donn et l'insre  l'autre
  # emplacement indiqu
  def inserer_echanger(ind1, ind2)
    if ind2 == 0
      tmp = ind1
      ind1 = ind2
      ind2 = tmp
    end
    temp = self[ind1]
    self.delete_at(ind1)
    self.replace(self[0..ind2-1]+[temp]+self[ind2..self.size])
  end



  # Supprime toutes les occurrences de string correspondant  la regexp
  # reg : regexp utilise
  def delete_reg!(reg)
    return if reg == nil
    return array_reg(reg, false)
  end


  # Garde uniquement les occurrences de string correspondant  la regexp
  # reg : regexp utilise
  def keep_reg!(reg)
    return if reg == nil
    return array_reg(reg, true)
  end

  def keep_reg(reg)
    return self if reg == nil
    arr = self.clone
    return arr.delete_reg!(reg)
  end


  def extract_reg(reg)
    extract = array_reg(reg, false)
    return extract
  end

  
  # Garde les strings dont le basename correspond  la regexp
  def keep_reg_basename(reg)
    return if reg == nil
    i = 0
    while i < self.size
      name = self.at(i)
      if reg.match(File.basename(name)) == nil
        self.delete_at(i)
      else
        i += 1
      end
    end
  end



  # Fonction utilise par delete_reg! et keep_reg!
  def array_reg(reg, bool)
    i = 0
    list = []
    while i < self.size
      if (reg.match(self.at(i)) == nil) == bool
        list << self.delete_at(i)
        next
      end
      i += 1
    end
    return list
  end
  private :array_reg


  def chacun_nb_index(index)
    liste = []
    for chacun in self
      liste << chacun[index]
    end
    return liste
  end


  def str_biggest
    sz = 0
    for str in self
      if str.size > sz
        sz = str.size
        st = str
      end
    end
    return st
  end

  def all_to_i
    return self.collect{ |x|
      x = x.to_i
    }
  end

  def all_to_f
    return self.collect{ |x|
      x = x.to_f
    }
  end


  def soustraction(val)
    new_arr = []
    if val.is_a?(Array)
      for i in 0...self.size
        new_arr[i] = self.at(i) - val.at(i)
      end
    else
      for i in 0...self.size
        new_arr[i] = self.at(i) - val
      end
    end
    return new_arr
  end


  def soustraction!(val)
    if val.is_a?(Array)
      for i in 0...self.size
        self[i] -= val[i]
      end
    else
      for i in 0...self.size
        self[i] -= val
      end
    end
  end


  def addition(arr)
    new_arr = []
    for i in 0...self.size
      new_arr[i] = self.at(i) + arr.at(i)
    end
    return new_arr
  end


  def addition!(val)
    if val.is_a?(Array)
      for i in 0...self.size
        self[i] += val[i]
      end
    else
      for i in 0...self.size
        self[i] = self.at(i) + val
      end
    end
  end


  def multiplication(val)
    new_arr = []
    if val.is_a?(Array)
      for i in 0...self.size
        new_arr[i] = self.at(i) * val.at(i)
      end
    else
      for i in 0...self.size
        new_arr[i] = self.at(i) * val
      end
    end
    return new_arr
  end


  def multiplication!(val)
    if val.is_a?(Array)
      for i in 0...self.size
        self[i] *= val.at(i)
      end
    else
      #self.each{|x|
      #  x *= val
      #}
      for i in 0...self.size
        self[i] *= val
      end
    end
  end


  def delete_negative!
    for i in 0...self.size
      self[i] = 0 if self.at(i) < 0
    end
  end


  def invert
    arr = []
    (self.size-1).downto(0){|i|
      arr << self.at(i)
    }
    return arr
  end


  def invert!
    inv = self.invert
    self.replace(inv)
    return self
  end


  def double(array)
    lst = []
    for elem in self
      lst << elem if array.include?(elem)
    end
    return lst
  end


  def rsame
    return 0 if self.size == 0
    return 1 if self.size == 1
    sam = self.last
    total = 1
    (self.size-2).downto(0){|x|
      break if self.at(x) != sam
      total += 1
    }
    return total

  end


  def nb_equal(array)
    nb = 0
    for i in 0...self.size
      nb += 1 if self.at(i) == array.at(i)
    end
    return nb
  end



  def randomize
    return self.sort_by {rand}
  end

  def randomize!
    return self.sort_by! {rand}
  end

  def rand
    return self[super(self.size)]
  end


end

